import { supabase } from '@/config/supabase';
import {
  GreetingType,
  GreetingTemplate,
  GreetingSchedule,
  GreetingLog,
  CreateTemplateRequest,
  UpdateSettingsRequest
} from './types';

export const greetingsService = {
  // Create or update greeting template
  async upsertTemplate(vendor_id: string, req: CreateTemplateRequest) {
    // Upsert by vendor_id + type
    const { data, error } = await supabase.from('greeting_templates').upsert({
      vendor_id,
      type: req.type,
      message: req.message,
      send_time: req.send_time
    }, { onConflict: 'vendor_id,type' }).select().single();
    return { data, error };
  },

  // Get all templates for vendor
  async getTemplates(vendor_id: string) {
    const { data, error } = await supabase.from('greeting_templates').select('*').eq('vendor_id', vendor_id);
    return { data, error };
  },

  // Update greeting settings (enable/disable types)
  async updateSettings(vendor_id: string, req: UpdateSettingsRequest) {
    // Upsert by vendor_id
    const { data, error } = await supabase.from('greeting_schedules').upsert({
      vendor_id,
      ...req
    }, { onConflict: 'vendor_id' }).select().single();
    return { data, error };
  },

  // Get greeting logs (with filters)
  async getLogs(vendor_id: string, filters: any) {
    let query = supabase.from('greeting_logs').select('*').eq('vendor_id', vendor_id);
    if (filters.type) query = query.eq('type', filters.type);
    if (filters.status) query = query.eq('status', filters.status);
    if (filters.date_range) {
      const [from, to] = filters.date_range;
      query = query.gte('created_at', from).lte('created_at', to);
    }
    const { data, error } = await query.order('created_at', { ascending: false });
    return { data, error };
  }
}; 